-- V2D - 12549 Messaging for Leave Creation Event
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Leave Management');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'SR_STUDENT_LEAVE_APPROVE');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='SR_STUDENT_LEAVE_APPROVE');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'STUDENT_LEAVE_APPROVE', 'Student Leave Approve', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Student Leave Approve');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SR_STUDENT_LEAVE_APPROVE_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'SR_STUDENT_LEAVE_APPROVE_RCPNT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_STUDENT_LEAVE_APPROVE_RCPNT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'SR_STUDENT_LEAVE_APPROVE_RCPNT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_STUDENT_LEAVE_APPROVE_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SR_STUDENT_LEAVE_APPROVE_RCPNT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_STUDENT_LEAVE_APPROVE_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select T1.id as USER_ID from service_requests T1 where T1.id in(namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='SR_STUDENT_LEAVE_APPROVE_RCPNT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    T1.requestId AS REQUEST_ID,
    T6.emailId AS EMAIL_ID,
    T6.mobileNumber AS MOBILE_NO,
    T6.mobileCountryCode AS MOBILE_CODE,
    T6.printName AS PRINT_NAME,
    T6.firstName AS FIRST_NAME,
    T6.middleName AS MIDDLE_NAME,
    T6.lastName AS LAST_NAME,
    T12.academyName AS ACADEMY_NAME,
    T12.locationName AS LOCATION_NAME,
    T12.displayName AS ACADEMY_NAME_LOCATION,
    T12.id AS ACADEMY_LOCATION_ID,
    (CASE
        WHEN
            T12.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.headerUrl)
        ELSE NULL
    END) AS HEADER_URL,
    (CASE
        WHEN
            T12.footerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T12.footerUrl)
        ELSE NULL
    END) AS FOOTER_URL,
	(CASE
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T12.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T12.logoUrl)
    END) AS LOGO_URL
FROM
    service_requests AS T1
        LEFT JOIN
    service_request_settings T7 ON T7.id = T1.serviceRequestSettingId
        LEFT JOIN
    students AS T5 ON T5.userId = T1.requester
        INNER JOIN
    persons AS T6 ON T6.id = T5.personId
        LEFT OUTER JOIN
    academy_location T12 ON T12.id = T7.academyLocationId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
WHERE
    T1.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "requestId",
            "resultKey": "REQUEST_ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "id",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 7
        }
    ]
}');



SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='STUDENT_LEAVE_APPROVE');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='SR_STUDENT_LEAVE_APPROVE');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='SR_STUDENT_LEAVE_APPROVE_RCPNT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Student Leave Approve',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Student Leave Approve',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Request for Leave Request','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Your $recipientData[&quot;REQUEST_ID&quot;] for Institute pass has been approved successfully.</span></span></p>
<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards, <br />
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>		
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Request for Leave Request','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Your $recipientData[&quot;REQUEST_ID&quot;] for Institute pass has been approved successfully.</span></span></p>
<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards, <br />
<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>		
			</td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;], Your request for Institute pass has been approved successfully.');




-- End Messaging for STUDENT_LEAVE_APPROVE Event
